#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"
#include "areas/2/custom.model.inc.h"
#include "levels/jrb/header.h"
extern u8 _jrb_segment_ESegmentRomStart[]; 
extern u8 _jrb_segment_ESegmentRomEnd[];
#include "levels/lll/header.h"
const LevelScript level_jrb_entry[] = {
INIT_LEVEL(),
LOAD_MIO0(0x07, _lll_segment_7SegmentRomStart, _lll_segment_7SegmentRomEnd),
LOAD_RAW(0x1A, _lllSegmentRomStart, _lllSegmentRomEnd),
LOAD_RAW(0x0E, _jrb_segment_ESegmentRomStart, _jrb_segment_ESegmentRomEnd),
LOAD_MIO0(0xA,_water_skybox_mio0SegmentRomStart,_water_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8,_common0_mio0SegmentRomStart,_common0_mio0SegmentRomEnd),
LOAD_RAW(15,_common0_geoSegmentRomStart,_common0_geoSegmentRomEnd),
LOAD_MIO0(5,_group2_mio0SegmentRomStart,_group2_mio0SegmentRomEnd),
LOAD_RAW(12,_group2_geoSegmentRomStart,_group2_geoSegmentRomEnd),
LOAD_MIO0(6,_group17_mio0SegmentRomStart,_group17_mio0SegmentRomEnd),
LOAD_RAW(13,_group17_geoSegmentRomStart,_group17_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_03,                  lll_geo_0009E0),
    LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_04,                  lll_geo_0009F8),
    LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_05,                  lll_geo_000A10),
    LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_06,                  lll_geo_000A28),
    LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_07,                  lll_geo_000A40),
    LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_08,                  lll_geo_000A60),
    LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_0A,                  lll_geo_000A90),
    LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_0B,                  lll_geo_000AA8),
    LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_0C,                  lll_geo_000AC0),
    LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_0D,                  lll_geo_000AD8),
    LOAD_MODEL_FROM_GEO(MODEL_LEVEL_GEOMETRY_0E,                  lll_geo_000AF0),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_DRAWBRIDGE_PART,                lll_geo_000B20),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_ROTATING_BLOCK_FIRE_BARS,       lll_geo_000B38),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_ROTATING_HEXAGONAL_RING,        lll_geo_000BB0),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_SINKING_RECTANGULAR_PLATFORM,   lll_geo_000BC8),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_SINKING_SQUARE_PLATFORMS,       lll_geo_000BE0),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_TILTING_SQUARE_PLATFORM,        lll_geo_000BF8),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_BOWSER_PIECE_1,                 lll_geo_000C10),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_BOWSER_PIECE_2,                 lll_geo_000C30),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_BOWSER_PIECE_3,                 lll_geo_000C50),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_BOWSER_PIECE_4,                 lll_geo_000C70),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_BOWSER_PIECE_5,                 lll_geo_000C90),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_BOWSER_PIECE_6,                 lll_geo_000CB0),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_BOWSER_PIECE_7,                 lll_geo_000CD0),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_BOWSER_PIECE_8,                 lll_geo_000CF0),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_BOWSER_PIECE_9,                 lll_geo_000D10),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_BOWSER_PIECE_10,                lll_geo_000D30),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_BOWSER_PIECE_11,                lll_geo_000D50),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_BOWSER_PIECE_12,                lll_geo_000D70),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_BOWSER_PIECE_13,                lll_geo_000D90),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_BOWSER_PIECE_14,                lll_geo_000DB0),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_MOVING_OCTAGONAL_MESH_PLATFORM, lll_geo_000B08),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_SINKING_ROCK_BLOCK,             lll_geo_000DD0),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_ROLLING_LOG,                    lll_geo_000DE8),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_ROTATING_HEXAGONAL_PLATFORM,    lll_geo_000A78),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_WOOD_BRIDGE,                    lll_geo_000B50),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_LARGE_WOOD_BRIDGE,              lll_geo_000B68),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_FALLING_PLATFORM,               lll_geo_000B80),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_LARGE_FALLING_PLATFORM,         lll_geo_000B98),
    LOAD_MODEL_FROM_GEO(MODEL_LLL_VOLCANO_FALLING_TRAP,           lll_geo_000EA8),
LOAD_MODEL_FROM_GEO(22, warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23, bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24, spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25, snow_tree_geo),
LOAD_MODEL_FROM_GEO(27, palm_tree_geo),
LOAD_MODEL_FROM_GEO(31, metal_door_geo),
LOAD_MODEL_FROM_GEO(32, hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34, castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35, castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36, castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37, key_door_geo),
LOAD_MODEL_FROM_GEO(38, castle_door_geo),
// LOAD_MODEL_FROM_DL(132,0x08025f08,4),
// LOAD_MODEL_FROM_DL(158,0x0302c8a0,4),
// LOAD_MODEL_FROM_DL(159,0x0302bcd0,4),
// LOAD_MODEL_FROM_DL(161,0x0301cb00,4),
// LOAD_MODEL_FROM_DL(164,0x04032a18,4),
// LOAD_MODEL_FROM_DL(201,0x080048e0,4),
// LOAD_MODEL_FROM_DL(218,0x08024bb8,4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_3),
JUMP_LINK(script_func_global_18),
JUMP_LINK(local_area_jrb_1_),
JUMP_LINK(local_area_jrb_2_),
FREE_LEVEL_POOL(),
MARIO_POS(1,0,0,0,0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};
const LevelScript local_area_jrb_1_[] = {
AREA(1,Geo_jrb_1_0x12f81e0),
TERRAIN(col_jrb_1_0xe021220),
SET_BACKGROUND_MUSIC(0,3),
TERRAIN_TYPE(0),
JUMP_LINK(local_objects_jrb_1_),
JUMP_LINK(local_warps_jrb_1_),
END_AREA(),
RETURN()
};
const LevelScript local_objects_jrb_1_[] = {
OBJECT_WITH_ACTS(0,0,630,0,0,180,0,0xa0000, bhvSpinAirborneWarp,31),
OBJECT_WITH_ACTS(207,1878,-171,2027,0,50,0,0x0, bhvFloorSwitchHiddenObjects,31),
OBJECT_WITH_ACTS(129,-2860,331,3185,0,346,0,0x0, bhvHiddenObject,31),
OBJECT_WITH_ACTS(129,-2860,531,3185,0,346,0,0x0, bhvHiddenObject,31),
OBJECT_WITH_ACTS(122,1425,3660,3330,0,119,0,0x0, bhvStar,31),
OBJECT_WITH_ACTS(122,-7053,2460,-19694,0,305,0,0x1000000, bhvStar,31),
OBJECT_WITH_ACTS(206,-2368,1140,-6073,0,0,0,0x0, bhvSnufit,31),
OBJECT_WITH_ACTS(206,-5536,1920,-9553,0,0,0,0x0, bhvSnufit,31),
OBJECT_WITH_ACTS(86,2525,2323,-12280,0,0,0,0x0, bhvSmallBully,31),
OBJECT_WITH_ACTS(86,2223,1667,-9917,0,0,0,0x0, bhvSmallBully,31),
OBJECT_WITH_ACTS(0,-3164,0,-1256,0,0,0,0x0, bhvGoombaTripletSpawner,31),
OBJECT_WITH_ACTS(55,1254,960,-12135,0,32,0,0x0, bhvLllSinkingRockBlock,31),
OBJECT_WITH_ACTS(55,-1461,960,-12597,0,319,0,0x0, bhvLllSinkingRockBlock,31),
OBJECT_WITH_ACTS(55,-670,960,-13843,0,0,0,0x0, bhvLllSinkingRockBlock,31),
OBJECT_WITH_ACTS(55,901,960,-13830,0,68,0,0x0, bhvLllSinkingRockBlock,31),
OBJECT_WITH_ACTS(55,-44,960,-14790,0,318,0,0x0, bhvLllSinkingRockBlock,31),
OBJECT_WITH_ACTS(87,-616,-241,-12024,0,0,0,0x4000000, bhvBigBully,31),
OBJECT_WITH_ACTS(140,-5068,1796,-5300,0,0,0,0x0, bhvBlueCoinSwitch,31),
OBJECT_WITH_ACTS(118,-4889,2054,-6475,0,87,0,0x0, bhvHiddenBlueCoin,31),
OBJECT_WITH_ACTS(118,-4902,2204,-7164,0,87,0,0x0, bhvHiddenBlueCoin,31),
OBJECT_WITH_ACTS(118,-4889,2359,-7940,0,87,0,0x0, bhvHiddenBlueCoin,31),
OBJECT_WITH_ACTS(0,576,2161,-8579,0,269,0,0x0, bhvCoinFormation,31),
OBJECT_WITH_ACTS(137,3174,2386,-5254,0,161,0,0x60000, bhvExclamationBox,31),
OBJECT_WITH_ACTS(0,-5695,661,-6199,0,8,0,0x0, bhvCoinFormation,31),
OBJECT_WITH_ACTS(0,1298,751,1769,0,139,0,0x0, bhvCoinFormation,31),
OBJECT_WITH_ACTS(215,2197,150,-2267,0,0,0,0x0, bhvRedCoin,31),
OBJECT_WITH_ACTS(215,-5526,490,1060,0,96,0,0x0, bhvRedCoin,31),
OBJECT_WITH_ACTS(215,-6771,84,-7613,0,0,0,0x0, bhvRedCoin,31),
OBJECT_WITH_ACTS(215,-3916,1304,-5823,0,0,0,0x0, bhvRedCoin,31),
OBJECT_WITH_ACTS(215,2201,1304,-6462,0,0,0,0x0, bhvRedCoin,31),
OBJECT_WITH_ACTS(215,-4027,2171,-14550,0,0,0,0x0, bhvRedCoin,31),
OBJECT_WITH_ACTS(215,-5266,2057,-11525,0,0,0,0x0, bhvRedCoin,31),
OBJECT_WITH_ACTS(215,-6776,671,-9783,0,137,0,0x0, bhvRedCoin,31),
OBJECT_WITH_ACTS(0,-1998,-47,-2566,0,177,0,0x0, bhvCoinFormation,31),
OBJECT_WITH_ACTS(0,-1304,-443,-7447,0,271,0,0x0, bhvCoinFormation,31),
OBJECT_WITH_ACTS(0,1908,-353,-7723,0,150,0,0x0, bhvCoinFormation,31),
OBJECT_WITH_ACTS(0,596,1579,-8569,0,0,0,0x3000000, bhvHiddenRedCoinStar,31),
OBJECT_WITH_ACTS(0,-2876,960,-9967,0,0,0,0x0, bhvGoombaTripletSpawner,31),
OBJECT_WITH_ACTS(0,-3308,960,-8111,0,177,0,0x20000, bhvCoinFormation,31),
OBJECT_WITH_ACTS(0,-8918,2195,-15050,0,181,0,0x40000, bhvCoinFormation,31),
OBJECT_WITH_ACTS(0,1733,-383,-12756,0,165,0,0x0, bhvCoinFormation,31),
OBJECT_WITH_ACTS(206,1879,2240,1860,0,0,0,0x0, bhvSnufit,31),
OBJECT_WITH_ACTS(0,74,1315,-12998,0,0,0,0x2000000, bhvHiddenStar,31),
OBJECT_WITH_ACTS(116,-1458,1170,-12579,0,0,0,0x0, bhvOneCoin,31),
OBJECT_WITH_ACTS(116,-685,1170,-13868,0,0,0,0x0, bhvOneCoin,31),
OBJECT_WITH_ACTS(116,-45,1170,-14777,0,0,0,0x0, bhvOneCoin,31),
OBJECT_WITH_ACTS(116,919,1170,-13829,0,0,0,0x0, bhvOneCoin,31),
OBJECT_WITH_ACTS(116,1262,1170,-12149,0,0,0,0x0, bhvOneCoin,31),
OBJECT_WITH_ACTS(0,-1437,1081,-12590,0,320,0,0x0, bhvHiddenStarTrigger,31),
OBJECT_WITH_ACTS(0,-684,1081,-13874,0,359,0,0x0, bhvHiddenStarTrigger,31),
OBJECT_WITH_ACTS(0,-56,1081,-14787,0,320,0,0x0, bhvHiddenStarTrigger,31),
OBJECT_WITH_ACTS(0,919,1081,-13845,0,340,0,0x0, bhvHiddenStarTrigger,31),
OBJECT_WITH_ACTS(0,1244,1081,-12158,0,34,0,0x0, bhvHiddenStarTrigger,31),
OBJECT_WITH_ACTS(137,-7993,2124,-9719,0,257,0,0x60000, bhvExclamationBox,31),
OBJECT_WITH_ACTS(0,410,1612,-18876,0,271,0,0x0, bhvCoinFormation,31),
OBJECT_WITH_ACTS(212,1665,2043,-13097,0,0,0,0x0, bhv1Up,31),
OBJECT_WITH_ACTS(206,-2935,2043,-13882,0,0,0,0x0, bhvSnufit,31),
OBJECT_WITH_ACTS(192,-2180,2197,1951,0,0,0,0x0, bhvGoomba,31),
OBJECT_WITH_ACTS(192,-3517,2197,1634,0,0,0,0x0, bhvGoomba,31),
OBJECT_WITH_ACTS(0,3239,751,-1054,0,170,0,0x0, bhvCoinFormation,31),
OBJECT_WITH_ACTS(192,-8900,2195,-15491,0,0,0,0x0, bhvGoomba,31),
OBJECT_WITH_ACTS(206,1339,-392,-10065,0,0,0,0x0, bhvSnufit,31),
OBJECT_WITH_ACTS(137,-2378,445,1109,0,173,0,0x50000, bhvExclamationBox,31),
OBJECT_WITH_ACTS(137,-1258,-103,-10710,0,173,0,0x50000, bhvExclamationBox,31),
OBJECT_WITH_ACTS(188,-915,-149,2467,0,0,0,0x0, bhvBobomb,31),
OBJECT_WITH_ACTS(206,970,1510,-8418,0,0,0,0x0, bhvSnufit,31),
OBJECT_WITH_ACTS(0,445,1357,-17679,0,0,0,0x14010000, bhvWarp,31),
OBJECT_WITH_ACTS(23,1889,-171,-618,0,0,0,0x0, bhvTree,31),
OBJECT_WITH_ACTS(23,-1273,-171,-3513,0,0,0,0x0, bhvTree,31),
OBJECT_WITH_ACTS(23,-6076,-171,-7255,0,0,0,0x0, bhvTree,31),
OBJECT_WITH_ACTS(23,-1295,960,-6435,0,0,0,0x0, bhvTree,31),
OBJECT_WITH_ACTS(23,-1364,960,-10290,0,0,0,0x0, bhvTree,31),
OBJECT_WITH_ACTS(86,2102,2353,-13893,0,0,0,0x0, bhvSmallBully,31),
OBJECT_WITH_ACTS(0,-995,1464,-8352,0,177,0,0x0, bhvCoinFormation,31),
OBJECT_WITH_ACTS(206,-6121,694,-10409,0,0,0,0x0, bhvSnufit,31),
RETURN()
};
const LevelScript local_warps_jrb_1_[] = {
WARP_NODE(10,9,1,0,0),
WARP_NODE(1,12,2,10,0),
WARP_NODE(240,16,1,49,0),
WARP_NODE(241,16,1,50,0),
RETURN()
};
const LevelScript local_area_jrb_2_[] = {
AREA(2,Geo_jrb_2_0x12f80d0),
TERRAIN(col_jrb_2_0xe00f160),
SET_BACKGROUND_MUSIC(0,9),
TERRAIN_TYPE(0),
JUMP_LINK(local_objects_jrb_2_),
JUMP_LINK(local_warps_jrb_2_),
END_AREA(),
RETURN()
};
const LevelScript local_objects_jrb_2_[] = {
OBJECT_WITH_ACTS(0,0,690,0,0,180,0,0xa0000, bhvSpinAirborneWarp,31),
OBJECT_WITH_ACTS(122,483,-8160,3187,0,93,0,0x5000000, bhvStar,31),
OBJECT_WITH_ACTS(120,8385,-3242,-15529,0,207,0,0x0, bhvRecoveryHeart,31),
RETURN()
};
const LevelScript local_warps_jrb_2_[] = {
WARP_NODE(10,9,2,0,0),
WARP_NODE(240,16,1,49,0),
WARP_NODE(241,16,1,50,0),
RETURN()
};
